local function IsWaterTileType(ground)
	return (ground == GROUND.OCEAN_SHALLOW or ground == GROUND.OCEAN_MEDIUM or ground == GROUND.OCEAN_DEEP or ground == GROUND.OCEAN_CORAL or ground == GROUND.MANGROVE or ground == GROUND.OCEAN_SHIPGRAVEYARD)
end

function GetClosestInstWithTag(tag, inst, radius)
        local trans = inst.Transform
        local tags = {tag}
        local x,y,z = trans:GetWorldPosition()
        local ents = TheSim:FindEntities(x,y,z, radius, tags)
        for k,v in pairs(ents) do
            if v ~= inst then return v end
        end
end

local function PlayerClose(inst)
	local player = GetClosestInstWithTag("player",inst,60)
	if player then
		return true
	else
		return false
	end
end

local function PlayerMainBaseClose(inst)
	local mainbase = GetClosestInstWithTag("prototyper",inst,60)
	if mainbase then
		return true
	else
		return false
	end
end

local function ShadowSoundDistant(boss)
	local sound = CreateEntity()
    sound.entity:AddTransform()
    sound.entity:AddSoundEmitter()
    sound.persists = false
	local theta = math.random() * 2 * PI
	local radius = 5
	local offset = Vector3(GetPlayer().Transform:GetWorldPosition()) +  Vector3(radius * math.cos( theta ), 0, -radius * math.sin( theta ))
	sound.Transform:SetPosition(offset.x,offset.y,offset.z)
	sound.SoundEmitter:PlaySound("dontstarve/cave/nightmare_end")
	sound:DoTaskInTime(1.5, function() sound:Remove() end)
end	

local MOB_DELAY = TUNING.SHADOW_SPAWN_FREQUENCE
local MOB_DELAY_RANDOM = TUNING.SHADOW_SPAWN_FREQUENCE/3

local ShadowPiecesSW = Class(function(self, inst)
	self.inst = inst
	self.mobspawndelay = MOB_DELAY + math.random(0,MOB_DELAY_RANDOM)
	self.randommob = nil
	self.inst:StartUpdatingComponent(self)
end)

function ShadowPiecesSW:OnUpdate()
	local day = GetClock().numcycles + 1
	local firstday = TUNING.SHADOW_MOONEVENT_FIRSTDAY
	local moonevent = TUNING.SHADOW_MOONEVENT_SPAWN
	if day >= firstday then
		if(moonevent == 1 and GetClock():IsNight() and GetClock():GetMoonPhase() == "new") then	
			self:SpawnMob()	
		elseif(moonevent == 2 and GetClock():IsNight() and GetClock():GetMoonPhase() == "full") then	
			self:SpawnMob()	
		elseif(moonevent == 3 and GetClock():IsNight() and (GetClock():GetMoonPhase() == "new" or GetClock():GetMoonPhase() == "full")) then	
			self:SpawnMob()	
		elseif(moonevent == 4 and GetClock():IsNight()) then	
			self:SpawnMob()	
		end
	end
end

function ShadowPiecesSW:GetFloorSpawnPoint(pt, radius)
	if GetPlayer():HasTag("aquatic") then 
		return 
	end 
    local theta = math.random() * 2 * PI
	local offset = FindWalkableOffset(pt, theta, radius, 12, true)
	if offset then
		local pos = pt+offset
		local ground = GetWorld()
	    local tile = GROUND.GRASS
	    if ground and ground.Map then
	        tile = self.inst:GetCurrentTileType(pos:Get())
	    end
		local onWater = ground.Map:IsWater(tile)
		if not onWater then 
			return pos
		end 
	end
end

function ShadowPiecesSW:SpawnMob()
	self.mobspawndelay = self.mobspawndelay - 1
	if self.mobspawndelay == 0 then
		local sound = CreateEntity()
		sound.entity:AddTransform()
		sound.entity:AddSoundEmitter()
		sound.persists = false
		local sm = GetSeasonManager()
		local pt = Vector3(GetPlayer().Transform:GetWorldPosition())
		local spawn_pt = self:GetFloorSpawnPoint(pt,math.random(30,60))
		--if spawn_pt and not PlayerMainBaseClose(GetPlayer()) then
		if spawn_pt then
			local pos = Vector3(GetPlayer().Transform:GetWorldPosition())
			local ground = GetWorld()  
			local tile = ground.Map:GetTileAtPoint(pos.x, pos.y, pos.z)
			local chance = math.random(1,3)
			local new_spawn_pt = self:GetFloorSpawnPoint(pt,30)
			if new_spawn_pt then
				if chance == 1 then
					self.randommob = SpawnPrefab("shadow_knight")
				elseif chance == 2 then
					self.randommob = SpawnPrefab("shadow_rook")
				elseif chance == 3 then
					self.randommob = SpawnPrefab("shadow_bishop")	
				end
				sound:DoTaskInTime(0, function() ShadowSoundDistant() end)
				--sound:DoTaskInTime(0, function() GetPlayer().components.talker:Say("I'm now hearing weird sounds thanks to my madness.") end)
				self.randommob.Physics:Teleport(new_spawn_pt:Get())
				self.mobspawndelay = MOB_DELAY + math.random(0,MOB_DELAY_RANDOM)
				print("Shadow Pieces succes!")
			else
				print("Shadow Pieces failed!")
				self.mobspawndelay = 1
			end
		else
			print("Shadow Pieces failed!")
			self.mobspawndelay = 1	
		end
	end
end

return ShadowPiecesSW